class Api {
    constructor(url, username, password, lang) {
        this.token = '';
        this.url = url;
        this.username = username;
        this.password = password;
        this.lang = lang;
        this.session = axios.create({
            baseURL: this.url,
            timeout: 30000,
            retry: function (retries, error) {
                if (retries >= 7) {
                    return false;
                }
                if (error.response && [502, 503, 504].includes(error.response.status)) {
                    return true;
                }
                return false;
            }
        });
    }

    async getToken() {
        if (this.token !== '') {
            return this.token;
        }

        var md5 = function(d){var r = M(V(Y(X(d),8*d.length)));return r.toLowerCase()};function M(d){for(var _,m="0123456789ABCDEF",f="",r=0;r<d.length;r++)_=d.charCodeAt(r),f+=m.charAt(_>>>4&15)+m.charAt(15&_);return f}function X(d){for(var _=Array(d.length>>2),m=0;m<_.length;m++)_[m]=0;for(m=0;m<8*d.length;m+=8)_[m>>5]|=(255&d.charCodeAt(m/8))<<m%32;return _}function V(d){for(var _="",m=0;m<32*d.length;m+=8)_+=String.fromCharCode(d[m>>5]>>>m%32&255);return _}function Y(d,_){d[_>>5]|=128<<_%32,d[14+(_+64>>>9<<4)]=_;for(var m=1732584193,f=-271733879,r=-1732584194,i=271733878,n=0;n<d.length;n+=16){var h=m,t=f,g=r,e=i;f=md5_ii(f=md5_ii(f=md5_ii(f=md5_ii(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_ff(f=md5_ff(f=md5_ff(f=md5_ff(f,r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+0],7,-680876936),f,r,d[n+1],12,-389564586),m,f,d[n+2],17,606105819),i,m,d[n+3],22,-1044525330),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+4],7,-176418897),f,r,d[n+5],12,1200080426),m,f,d[n+6],17,-1473231341),i,m,d[n+7],22,-45705983),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+8],7,1770035416),f,r,d[n+9],12,-1958414417),m,f,d[n+10],17,-42063),i,m,d[n+11],22,-1990404162),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+12],7,1804603682),f,r,d[n+13],12,-40341101),m,f,d[n+14],17,-1502002290),i,m,d[n+15],22,1236535329),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+1],5,-165796510),f,r,d[n+6],9,-1069501632),m,f,d[n+11],14,643717713),i,m,d[n+0],20,-373897302),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+5],5,-701558691),f,r,d[n+10],9,38016083),m,f,d[n+15],14,-660478335),i,m,d[n+4],20,-405537848),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+9],5,568446438),f,r,d[n+14],9,-1019803690),m,f,d[n+3],14,-187363961),i,m,d[n+8],20,1163531501),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+13],5,-1444681467),f,r,d[n+2],9,-51403784),m,f,d[n+7],14,1735328473),i,m,d[n+12],20,-1926607734),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+5],4,-378558),f,r,d[n+8],11,-2022574463),m,f,d[n+11],16,1839030562),i,m,d[n+14],23,-35309556),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+1],4,-1530992060),f,r,d[n+4],11,1272893353),m,f,d[n+7],16,-155497632),i,m,d[n+10],23,-1094730640),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+13],4,681279174),f,r,d[n+0],11,-358537222),m,f,d[n+3],16,-722521979),i,m,d[n+6],23,76029189),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+9],4,-640364487),f,r,d[n+12],11,-421815835),m,f,d[n+15],16,530742520),i,m,d[n+2],23,-995338651),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+0],6,-198630844),f,r,d[n+7],10,1126891415),m,f,d[n+14],15,-1416354905),i,m,d[n+5],21,-57434055),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+12],6,1700485571),f,r,d[n+3],10,-1894986606),m,f,d[n+10],15,-1051523),i,m,d[n+1],21,-2054922799),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+8],6,1873313359),f,r,d[n+15],10,-30611744),m,f,d[n+6],15,-1560198380),i,m,d[n+13],21,1309151649),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+4],6,-145523070),f,r,d[n+11],10,-1120210379),m,f,d[n+2],15,718787259),i,m,d[n+9],21,-343485551),m=safe_add(m,h),f=safe_add(f,t),r=safe_add(r,g),i=safe_add(i,e)}return Array(m,f,r,i)}function md5_cmn(d,_,m,f,r,i){return safe_add(bit_rol(safe_add(safe_add(_,d),safe_add(f,i)),r),m)}function md5_ff(d,_,m,f,r,i,n){return md5_cmn(_&m|~_&f,d,_,r,i,n)}function md5_gg(d,_,m,f,r,i,n){return md5_cmn(_&f|m&~f,d,_,r,i,n)}function md5_hh(d,_,m,f,r,i,n){return md5_cmn(_^m^f,d,_,r,i,n)}function md5_ii(d,_,m,f,r,i,n){return md5_cmn(m^(_|~f),d,_,r,i,n)}function safe_add(d,_){var m=(65535&d)+(65535&_);return(d>>16)+(_>>16)+(m>>16)<<16|65535&m}function bit_rol(d,_){return d<<_|d>>>32-_}

        // generate md5 sum of username and url
        const md5sum = md5(this.username + this.url);

        // if there is token.txt file, read it
        const tokenFile = 'token_' + md5sum;
        const tokenCookie = document.cookie.split(';').find(cookie => cookie.trim().startsWith(tokenFile+'='));
        if (tokenCookie) {
            this.token = tokenCookie.split('=')[1];

            // check token by getting user info
            try {
                const response = await this.get(this.url + '/api/auth/user', {}, 30000, true);
                if (response.status !== 200) {
                    this.token = '';
                }
            } catch (error) {
                this.token = '';
            }
        }

        // if token is not empty, return it
        if (this.token !== '') {
            return this.token;
        }

        // if url, username or password is empty, exit
        if (this.url === '') {
            console.error('No URL specified');
            process.exit(1);
        }
        if (this.username === '') {
            console.error('No username specified');
            process.exit(1);
        }
        if (this.password === '') {
            console.error('No password specified');
            process.exit(1);
        }

        // if token is empty, get it from the API
        const args = {
            username: this.username,
            password: this.password,
            useragent: 'api request'
        };
        try {
            const response = await this.session.post('/api/auth/login', args);
            if (response.status !== 200) {
                console.error('Invalid credentials');
                console.error(response.status);
                process.exit(1);
            }

            const token = response.data.token.token_type + ' ' + response.data.token.access_token;
            this.token = token;

            // save token to token.txt file
            document.cookie = `${tokenFile}=${this.token}`;
        } catch (error) {
            console.error('Error:', error.response.status);
            console.error(error.config.url);
            console.error(error.config.data);
            console.error(error.response.data);
            process.exit(1);
        }

        return this.token;
    }

    async get(url, headers = {}, timeout = 30000, throwException = false) {
        const token = await this.getToken();
        headers = {
            ...headers,
            'Authorization': token,
            'Accept-Language': this.lang,
            'Accept': 'application/json'
        };

        try {
            const response = await this.session.get(url, {
                headers,
                timeout
            });
            return response;
        } catch (error) {
            if (throwException) {
                throw error;
            } else {
                console.error('Error:', error.response.status);
                console.error(url);
                console.error(error.request.data);
                console.error(error.response.data);
                process.exit(1);
            }
        }
    }

    async post(url, data = {}, headers = {}, timeout = 30000, throwException = false) {
        const token = await this.getToken();
        headers = {
            ...headers,
            'Authorization': token,
            'Accept-Language': this.lang,
            'Accept': 'application/json'
        };

        try {
            const response = await this.session.post(url, data, {
                headers,
                timeout
            });
            return response;
        } catch (error) {
            if (throwException) {
                throw error;
            } else {
                console.error('Error:', error.response.status);
                console.error(url);
                console.error(error.request.data);
                console.error(error.response.data);
                process.exit(1);
            }
        }
    }

    async delete(url, headers = {}, timeout = 30000, throwException = false) {
        const token = await this.getToken();
        headers = {
            ...headers,
            'Authorization': token,
            'Accept-Language': this.lang,
            'Accept': 'application/json'
        };

        try {
            const response = await this.session.delete(url, {
                headers,
                timeout
            });
            return response;
        } catch (error) {
            if (throwException) {
                throw error;
            } else {
                console.error('Error:', error.response.status);
                console.error(url);
                console.error(error.request.data);
                console.error(error.response.data);
                process.exit(1);
            }
        }
    }

    async put(url, data = {}, headers = {}, timeout = 30000, throwException = false) {
        const token = await this.getToken();
        headers = {
            ...headers,
            'Authorization': token,
            'Accept-Language': this.lang,
            'Accept': 'application/json'
        };

        try {
            const response = await this.session.put(url, data, {
                headers,
                timeout
            });
            return response;
        } catch (error) {
            if (throwException) {
                throw error;
            } else {
                console.error('Error:', error.response.status);
                console.error(url);
                console.error(error.request.data);
                console.error(error.response.data);
                process.exit(1);
            }
        }
    }

    async __all(method, endpoint, ...args) {
        const response = await this[method](endpoint, ...args);
        if (response.status !== 200) {
            console.error('Error:', response.status);
            console.error(endpoint);
            console.error(response.request.data);
            console.error(response.data);
            process.exit(1);
        }
        let data = response.data;
        let ret = data.data;

        if (!data.meta || !data.meta.per_page) {
            return ret;
        }

        const per_page = data.meta.per_page;

        let with_trashed = false;
        let only_trashed = false;
        if (endpoint.includes('with_trashed=')) {
            with_trashed = true;
        }
        if (endpoint.includes('only_trashed=')) {
            only_trashed = true;
        }

        while (data.links.next !== null) {
            try {
                const response = await this[method](
                    data.links.next +
                    '&limit=' +
                    per_page +
                    (with_trashed ? '&with_trashed=true' : '') +
                    (only_trashed ? '&only_trashed=true' : ''),
                    ...args
                );
                if (response.status !== 200) {
                    console.error('Error:', response.status);
                    console.error(endpoint);
                    console.error(response.request.data);
                    console.error(response.data);
                    process.exit(1);
                }
                data = response.data;
                ret = ret.concat(data.data);
            } catch (error) {
                console.error('Error:', error.response.status);
                console.error(endpoint);
                console.error(error.request.data);
                console.error(error.response.data);
                process.exit(1);
            }
        }
        return ret;
    }

    async getAll(endpoint, ...args) {
        return this.__all('get', endpoint, ...args);
    }

    async searchAll(endpoint, ...args) {
        return this.__all('post', endpoint + '/search', ...args);
    }

    async search(endpoint, ...args) {
        return this.post(endpoint + '/search', ...args);
    }

    throwErr(response) {
        console.error(response.request.url);
        console.error(response.request.data);
        console.error(response.status);
        console.error(response.data);
        process.exit(1);
    }
}

