import requests
import sys
import hashlib
import urllib3.util.retry

class Api:
    token = ""
    url = ""
    username = ""
    password = ""
    lang = ""
    session = None

    def __init__(self, url, username, password, lang):
        self.url = url
        self.username = username
        self.password = password
        self.lang = lang
        self.session = requests.Session()
        retries = urllib3.util.retry.Retry(
            total=7,
            backoff_factor=3,
            allowed_methods=frozenset(
                {"DELETE", "GET", "HEAD", "OPTIONS", "PUT", "TRACE", "POST", "PATCH"}
            ),
            status_forcelist=[502, 503, 504],
        )
        self.session.mount(self.url, requests.adapters.HTTPAdapter(max_retries=retries))
        self.session.headers.update({"Connection": "keep-alive"})

    def getToken(self):
        if self.token != "":
            return self.token

        # generate md5 sum of username and url
        m = hashlib.md5()
        m.update(self.username.encode("utf-8"))
        m.update(self.url.encode("utf-8"))
        md5sum = m.hexdigest()

        # if there is token.txt file, read it
        try:
            with open("token_" + md5sum + ".txt", "r") as file:
                self.token = file.read()
                # check token by getting user info
                response = self.get(self.url + "/api/auth/user")
                if response.status_code != 200:
                    self.token = ""
        except FileNotFoundError:
            pass

        # if token is not empty, return it
        if self.token != "":
            return self.token

        # if url, username or password is empty, exit
        if self.url == "":
            print("No URL specified")
            sys.exit(1)
        if self.username == "":
            print("No username specified")
            sys.exit(1)
        if self.password == "":
            print("No password specified")
            sys.exit(1)

        # if token is empty, get it from the API
        args = {
            "username": self.username,
            "password": self.password,
            "useragent": "api request",
        }
        response = requests.post(self.url + "/api/auth/login", json=args)
        if response.status_code != 200:
            print("Invalid credentials")
            print(response.status_code)
            sys.exit(1)

        token = response.json().get("token")
        self.token = token["token_type"] + " " + token["access_token"]

        # save token to token.txt file
        with open("token_" + md5sum + ".txt", "w") as file:
            file.write(self.token)

        return self.token

    # pass get, post and all other types of requests to requests library using self.url as URL - pass only endpoint
    def __getattr__(self, name):
        def wrapper(*args, **kwargs):
            headers = {
                "Authorization": self.getToken(),
                "Accept-Language": self.lang,
                "Accept": "application/json",
            }
            timeout = 30

            # merge headers with kwargs headers
            if "headers" in kwargs:
                headers = {**headers, **kwargs["headers"]}
                del kwargs["headers"]

            # merge headers with kwargs headers
            if "timeout" in kwargs:
                timeout = kwargs["timeout"]
                del kwargs["timeout"]

            if "url" in kwargs:
                # if url in kwargs doesn't start with http
                if kwargs["url"].startswith("http"):
                    url = kwargs["url"]
                else:
                    url = self.url + kwargs["url"]
                del kwargs["url"]
            else:
                # if url in kwargs doesn't start with http
                if args[0].startswith("http"):
                    url = args[0]
                else:
                    url = self.url + args[0]
                args = args[1:]

            return getattr(self.session, name)(
                url, headers=headers, timeout=timeout, *args, **kwargs
            )

        return wrapper

    def __all(self, method, endpoint, *args, **kwargs):
        response = getattr(self, method)(endpoint, *args, **kwargs)
        if response.status_code != 200:
            print("Error: " + str(response.status_code))
            print(endpoint)
            print(response.request.body)
            print(response.content.decode("utf-8"))
            sys.exit(1)
        data = response.json()
        # print(data)
        ret = data["data"]

        if not "meta" in data or not "per_page" in data["meta"]:
            return ret

        per_page = data["meta"]["per_page"]

        with_trashed = False
        only_trashed = False
        if "with_trashed=" in endpoint:
            with_trashed = True
        if "only_trashed=" in endpoint:
            only_trashed = True

        while "next" in data["links"] and data["links"]["next"] is not None:
            response = getattr(self, method)(
                data["links"]["next"]
                + "&limit="
                + str(per_page)
                + ("&with_trashed=true" if with_trashed else "")
                + ("&only_trashed=true" if only_trashed else ""),
                *args,
                **kwargs
            )
            if response.status_code != 200:
                print("Error: " + str(response.status_code))
                print(endpoint)
                print(response.request.body)
                print(response.content.decode("utf-8"))
                sys.exit(1)
            data = response.json()
            # append data["data"] to ret
            ret += data["data"]
        return ret

    def getAll(self, endpoint, *args, **kwargs):
        return self.__all("get", endpoint, *args, **kwargs)

    def searchAll(self, endpoint, *args, **kwargs):
        return self.__all("post", endpoint + "/search", *args, **kwargs)

    def search(self, endpoint, *args, **kwargs):
        return self.post(endpoint + "/search", *args, **kwargs)

    def throwErr(self, response):
        print(response.request.url)
        print(response.request.body)
        print(response.status_code)
        print(response.content.decode("utf-8"))
        sys.exit(1)
